/*
 * Decompiled with CFR 0.152.
 */
package apiipc.generated.events;

import apicore.message.IPCEventLTV;
import apicore.message.UUID;
import apicore.ptmp.PacketTracerSession;
import apiipc.generated.events.STPProcessEvent;
import apiipc.generated.events.STPProcessEventListener;
import apiipc.generated.sim.STPProcess;
import apiipc.ipc.IPCEventRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STPProcessEventRegistry
extends IPCEventRegistry {
    protected Set<STPProcessEventListener> globalListeners = new HashSet<STPProcessEventListener>();
    protected Map<String, Set<STPProcessEventListener>> specificObjectListeners = new HashMap<String, Set<STPProcessEventListener>>();

    public STPProcessEventRegistry(PacketTracerSession packetTracerSession) {
        super(packetTracerSession);
    }

    @Override
    public String getClassName() {
        return "STPProcess";
    }

    @Override
    public void processEvent(IPCEventLTV iPCEventLTV) {
        String string = iPCEventLTV.getEventName();
        STPProcessEvent sTPProcessEvent = null;
        if (string.equalsIgnoreCase("rootChanged")) {
            sTPProcessEvent = new STPProcessEvent.RootChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("stpPortStateChanged")) {
            sTPProcessEvent = new STPProcessEvent.StpPortStateChanged(iPCEventLTV);
        } else if (string.equalsIgnoreCase("rstpPortStateChanged")) {
            sTPProcessEvent = new STPProcessEvent.RstpPortStateChanged(iPCEventLTV);
        } else {
            return;
        }
        for (STPProcessEventListener object : this.globalListeners) {
            object.handleEvent(sTPProcessEvent);
        }
        Set<STPProcessEventListener> set = this.specificObjectListeners.get(sTPProcessEvent.objectUUID.toString());
        if (set != null) {
            for (STPProcessEventListener sTPProcessEventListener : set) {
                sTPProcessEventListener.handleEvent(sTPProcessEvent);
            }
        }
    }

    public void addListenerFiltered(STPProcessEventListener sTPProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() == 0) {
            if (list == null) {
                this.register("rootChanged");
                this.register("stpPortStateChanged");
                this.register("rstpPortStateChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(list.get(i));
                }
            }
        }
        this.globalListeners.add(sTPProcessEventListener);
    }

    public void addSpecificListenerFiltered(STPProcessEventListener sTPProcessEventListener, STPProcess sTPProcess, List<String> list) throws IOException {
        UUID uUID = sTPProcess.getObjectUUID();
        String string = uUID.toString();
        Set<STPProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set == null) {
            set = new HashSet<STPProcessEventListener>();
            this.specificObjectListeners.put(string, set);
            if (list == null) {
                this.register(uUID, "rootChanged");
                this.register(uUID, "stpPortStateChanged");
                this.register(uUID, "rstpPortStateChanged");
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    this.register(uUID, list.get(i));
                }
            }
        }
        set.add(sTPProcessEventListener);
    }

    public void removeListenerFiltered(STPProcessEventListener sTPProcessEventListener, List<String> list) throws IOException {
        if (this.globalListeners.size() != 0) {
            if (list == null) {
                this.deregister("rootChanged");
                this.deregister("stpPortStateChanged");
                this.deregister("rstpPortStateChanged");
            }
            this.globalListeners.remove(sTPProcessEventListener);
        }
    }

    public void removeSpecificListenerFiltered(STPProcessEventListener sTPProcessEventListener, STPProcess sTPProcess, List<String> list) throws IOException {
        UUID uUID = sTPProcess.getObjectUUID();
        String string = uUID.toString();
        Set<STPProcessEventListener> set = this.specificObjectListeners.get(string);
        if (set != null && !set.isEmpty()) {
            this.deregister(uUID, "rootChanged");
            this.deregister(uUID, "stpPortStateChanged");
            this.deregister(uUID, "rstpPortStateChanged");
            set.remove(sTPProcessEventListener);
        }
    }

    public void addListener(STPProcessEventListener sTPProcessEventListener) throws IOException {
        this.addListenerFiltered(sTPProcessEventListener, null);
    }

    public void addListener(STPProcessEventListener sTPProcessEventListener, STPProcess sTPProcess) throws IOException {
        this.addSpecificListenerFiltered(sTPProcessEventListener, sTPProcess, null);
    }

    public void removeListener(STPProcessEventListener sTPProcessEventListener) throws IOException {
        this.removeListenerFiltered(sTPProcessEventListener, null);
    }

    public void removeListener(STPProcessEventListener sTPProcessEventListener, STPProcess sTPProcess) throws IOException {
        this.removeSpecificListenerFiltered(sTPProcessEventListener, sTPProcess, null);
    }
}

